(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14050,        522]*)
(*NotebookOutlinePosition[     14897,        549]*)
(*  CellTagsIndexPosition[     14853,        545]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style. Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->GrayLevel[0]},
  ScriptMinSize->9,
  Background->RGBColor[0.91104, 0.923705, 0.119799]],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "ColorPrintout"],
  PageWidth->PaperWidth,
  Background->RGBColor[0.91104, 0.923705, 0.119799],
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{10, 20}, {8, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->{{100, 4}, {8, 10}},
  TextAlignment->Left,
  LineSpacing->{1, -5},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->48,
  FontWeight->"Bold",
  FontColor->RGBColor[0.920012, 0.0220188, 0.0587472]],

Cell[StyleData["Title", "Printout"],
  LineSpacing->{1, 0},
  FontSize->36,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Title", "ColorPrintout"],
  LineSpacing->{1, 0},
  FontSize->36]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{100, Inherited}, {2, 50}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->RGBColor[0.418997, 0.370581, 0.933791]],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{50, Inherited}, {0, 37}},
  FontSize->18,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Subtitle", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {0, 37}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{100, Inherited}, {6, 2}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{50, Inherited}, {6, 0}}],

Cell[StyleData["Subsubtitle", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {6, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellDingbat->None,
  CellMargins->{{25, 10}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{10, 4}, {6, 6}},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0.912505, 0.367178, 0.000564584]],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{20, 20}, {4, 20}},
  FontSize->12,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Section", "ColorPrintout"],
  CellMargins->{{20, 20}, {4, 20}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{100, 20}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{2, 12}, {0, 12}},
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{50, 20}, {4, 20}},
  FontSize->12],

Cell[StyleData["Subsection", "ColorPrintout"],
  CellMargins->{{50, 20}, {4, 20}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{100, Inherited}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsubsection",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{50, Inherited}, {4, 20}},
  FontSize->10],

Cell[StyleData["Subsubsection", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {4, 20}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellFrame->False,
  CellMargins->{{100, 20}, {7, 12}},
  CellFrameMargins->{{4, 10}, {6, 0}},
  CellFrameLabelMargins->4,
  LineSpacing->{1, 7},
  FontSize->14],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{50, 20}, {4, 8}},
  LineSpacing->{1, 5},
  FontSize->10],

Cell[StyleData["Text", "ColorPrintout"],
  CellMargins->{{50, 20}, {4, 8}},
  LineSpacing->{1, 5},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{100, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}},
  FontSize->8],

Cell[StyleData["SmallText", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}},
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{1, 1}, {0, 1}},
  CellMargins->{{100, 0}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.187182, 0.813901, 0.186114]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  FontSize->16,
  Background->GrayLevel[0.6]],

Cell[StyleData["Input", "ColorPrintout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  FontSize->16]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{1, 1}, {1, 0}},
  CellMargins->{{100, 0}, {Inherited, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  FontSize->18,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.0958877, 0.0436561, 0.956359]],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{50, 0}, {Inherited, 0}},
  FontSize->12,
  Background->GrayLevel[0.4]],

Cell[StyleData["Output", "ColorPrintout"],
  CellMargins->{{50, 0}, {Inherited, 0}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->1,
  CellMargins->{{100, 0}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.187182, 0.813901, 0.186114]],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  FontSize->16,
  Background->GrayLevel[0.6]],

Cell[StyleData["InputOnly", "ColorPrintout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{100, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{100, 20}, {3, 3}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  FormatType->InputForm,
  StyleMenuListing->None,
  Background->RGBColor[0.967727, 0.972747, 0.534508]],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{50, 20}, {2, 2}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Print", "ColorPrintout"],
  CellMargins->{{50, 20}, {2, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{100, 0}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[1]],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{50, 0}, {0, 0}},
  FontSize->10],

Cell[StyleData["Graphics", "ColorPrintout"],
  CellMargins->{{50, 0}, {0, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{100, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[1]],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{50, Inherited}, {0, 0}},
  FontSize->10],

Cell[StyleData["PictureGroup", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {0, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "ColorPrintout"],
  FontSize->8]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{482, 314},
WindowMargins->{{12, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 192, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1988, 61, 42, 0, 50, "Section"],
Cell[2033, 63, 151, 3, 52, 31, 0, "StyleData", "All", "Working"],
Cell[2187, 68, 104, 2, 36, 32, 0, "StyleData", "All", "Printout"],
Cell[2294, 72, 162, 3, 52, 37, 0, "StyleData", "All", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2493, 80, 35, 0, 38, "Section"],
Cell[2531, 82, 101, 3, 30, "Text"],
Cell[2635, 87, 398, 10, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3070, 102, 38, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[3133, 106, 482, 13, 83, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3618, 121, 104, 3, 70, 36, 0, "StyleData", "Title", "Printout"],
Cell[3725, 126, 80, 2, 70, 41, 0, "StyleData", "Title", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3842, 133, 390, 10, 55, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4235, 145, 127, 3, 71, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[4365, 150, 103, 2, 71, 44, 0, "StyleData", "Subtitle", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4505, 157, 316, 8, 49, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4824, 167, 84, 1, 37, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[4911, 170, 89, 1, 37, 47, 0, "StyleData", "Subsubtitle", "ColorPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[5037, 176, 444, 12, 52, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5484, 190, 119, 3, 59, 38, 0, "StyleData", "Section", "Printout"],
Cell[5606, 195, 95, 2, 59, 43, 0, "StyleData", "Section", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5738, 202, 363, 10, 46, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6104, 214, 93, 2, 53, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[6200, 218, 98, 2, 53, 46, 0, "StyleData", "Subsection", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6335, 225, 258, 7, 45, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[6596, 234, 103, 2, 50, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[6702, 238, 108, 2, 50, 49, 0, "StyleData", "Subsubsection", 
"ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6859, 246, 39, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[6923, 250, 186, 6, 50, 23, 0, "StyleData", "Text", "All"],
Cell[7112, 258, 109, 3, 39, 35, 0, "StyleData", "Text", "Printout"],
Cell[7224, 263, 114, 3, 39, 40, 0, "StyleData", "Text", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7375, 271, 153, 4, 43, 28, 0, "StyleData", "SmallText", "All"],
Cell[7531, 277, 113, 2, 32, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[7647, 281, 118, 2, 34, 45, 0, "StyleData", "SmallText", "ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7814, 289, 42, 0, 38, "Section"],
Cell[7859, 291, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[8132, 300, 550, 16, 55, 24, 0, "StyleData", "Input", "All"],
Cell[8685, 318, 124, 3, 53, 36, 0, "StyleData", "Input", "Printout"],
Cell[8812, 323, 99, 2, 53, 41, 0, "StyleData", "Input", "ColorPrintout"]
}, Closed]],
Cell[8926, 328, 375, 12, 45, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[9326, 344, 538, 15, 55, 25, 0, "StyleData", "Output", "All"],
Cell[9867, 361, 125, 3, 49, 37, 0, "StyleData", "Output", "Printout"],
Cell[9995, 366, 100, 2, 49, 42, 0, "StyleData", "Output", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10132, 373, 539, 16, 64, 28, 0, "StyleData", "InputOnly", "All"],
Cell[10674, 391, 128, 3, 54, 40, 0, "StyleData", "InputOnly", "Printout"],
Cell[10805, 396, 103, 2, 54, 45, 0, "StyleData", "InputOnly", "ColorPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[10945, 403, 539, 16, 44, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[11487, 421, 96, 1, 36, 38, 0, "StyleData", "Message", "Printout"],
Cell[11586, 424, 101, 1, 36, 43, 0, "StyleData", "Message", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11724, 430, 500, 14, 59, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[12227, 446, 122, 3, 47, 36, 0, "StyleData", "Print", "Printout"],
Cell[12352, 451, 92, 2, 47, 41, 0, "StyleData", "Print", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12481, 458, 443, 13, 40, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[12927, 473, 89, 2, 27, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[13019, 477, 94, 2, 27, 44, 0, "StyleData", "Graphics", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13150, 484, 334, 9, 40, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[13487, 495, 101, 2, 27, 43, 0, "StyleData", "PictureGroup", "Printout"],
Cell[13591, 499, 106, 2, 27, 48, 0, "StyleData", "PictureGroup", 
"ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13734, 506, 128, 4, 42, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[13865, 512, 82, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[13950, 516, 60, 1, 32, 45, 0, "StyleData", "CellLabel", "ColorPrintout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

